/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'BasicLineSegmentUI.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.plaf;

import geofasc.swing.AbstractFigure;
import geofasc.swing.LineSegment;
import geofasc.swing.model.LineSegmentModel;

import java.awt.Graphics;

import javax.swing.JComponent;


/**
 * Basic implementation of {@link LineSegmentUI}.
 *
 * @version 0.1 08/11/10
 * @author Christian Wolf
 */
public class BasicLineSegmentUI extends LineSegmentUI {

	/** {@inheritDoc} */
	@Override
	public boolean contains(JComponent c, int x, int y) {

		LineSegmentModel lineModel = ((LineSegment) c).getModel();

		if (lineModel == null)
			return super.contains(c, x, y);

		double x1, x2, y1, y2;
		x1 = lineModel.getFirstPointX();
		x2 = lineModel.getSecondPointX();
		y1 = lineModel.getFirstPointY();
		y2 = lineModel.getSecondPointY();

		if (x2 - x1 == 0)
			x2 += 0.000001;

		double res = (y2 - y1) * x / (x2 - x1) + (x2 * y1 - x1 * y2)
				/ (x2 - x1);

		return Math.abs(((double) y) - res) <= 10 && super.contains(c, x, y);
	}

	/** {@inheritDoc} */
	@Override
	protected void paintFigure(Graphics g, AbstractFigure f) {

		LineSegmentModel lineModel = ((LineSegment) f).getModel();

		if (lineModel == null || !f.isVisible())
			return;

		g.setColor(lineModel.getLineColor());
		g.drawLine(lineModel.getFirstPointX(), lineModel.getFirstPointY(),
				lineModel.getSecondPointX(), lineModel.getSecondPointY());
	}

}
