/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'Swarm.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import java.awt.Color;

import geofasc.swing.Circle;

@SuppressWarnings("serial")
public class Person extends Circle {

	private boolean mIsRed;

	public Person(int x, int y, boolean isRed) {
		super(x, y, 10);
		setRed(isRed);
		setFigureFilled(true);
	}

	public boolean isRed() {
		return mIsRed;
	}

	public void setRed(boolean convince) {
		if (mIsRed == convince)
			return;

		mIsRed = convince;

		if (mIsRed)
			setFigureFillColor(Color.RED);
		else
			setFigureFillColor(Color.BLACK);
	}

}
