package geofasc.swing.model;

import java.awt.Rectangle;

/**
 * <code>DefaultPointModel</code> is the default implementation of
 * {@link PointModel}. This class is inherited from {@link DefaultFigureModel}.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * 
 */
public class DefaultPointModel extends DefaultFigureModel {

	/** {@inheritDoc} */
	@Override
	public Rectangle getBounds() {
		return new Rectangle(round(mLocationX), round(mLocationY), 1, 1);
	}

	/** {@inheritDoc} */
	@Override
	public final boolean isFilled() {
		return false;
	}

}
