/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'DefaultRectangleModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

import java.awt.Dimension;

/**
 * <code>DefaultRectangleModel</code> is the default implementation of
 * {@link RectangleModel}. This class is inherited from
 * {@link DefaultFigureModelExtended}.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * 
 */
public class DefaultRectangleModel extends DefaultFigureModelExtended implements
		RectangleModel {

	private boolean mHasRoundedCorners;
	private int mArcHeight;
	private int mArcWidth;

	/** {@inheritDoc} */
	@Override
	public int getArcHeight() {
		return mArcHeight;
	}

	/** {@inheritDoc} */
	@Override
	public Dimension getArcSize() {
		return new Dimension(mArcWidth, mArcHeight);
	}

	/** {@inheritDoc} */
	@Override
	public int getArcWidth() {
		return mArcWidth;
	}

	/** {@inheritDoc} */
	@Override
	public boolean hasRoundedCorners() {
		return mHasRoundedCorners;
	}

	/** {@inheritDoc} */
	@Override
	public void setArcHeight(int arcHeight) {
		if (arcHeight == mArcHeight)
			return;

		mArcHeight = arcHeight;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setArcSize(Dimension d) {
		if (d != null)
			setSize(d.width, d.height);
	}

	/** {@inheritDoc} */
	@Override
	public void setArcSize(int arcWidth, int arcHeight) {
		if (arcWidth == mArcWidth && arcHeight == mArcHeight)
			return;

		mArcWidth = arcWidth;
		mArcHeight = arcHeight;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setArcWidth(int arcWidth) {
		if (arcWidth == mArcWidth)
			return;

		mArcWidth = arcWidth;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setRoundedCorners(boolean roundRect) {
		if (roundRect == mHasRoundedCorners)
			return;

		mHasRoundedCorners = roundRect;
		fireStateChanged();
	}

}
