/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'DefaultSquareModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

/**
 * <code>DefaultSquareModel</code> is the default implementation of
 * {@link SquareModel}. This class is inherited from
 * {@link DefaultRectangleModel}.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * 
 */
public class DefaultSquareModel extends DefaultRectangleModel implements
		SquareModel {

	/** {@inheritDoc} */
	@Override
	public int getLength() {
		return getWidth();
	}

	/** {@inheritDoc} */
	@Override
	public void setLength(int length) {
		super.setSize(length, length);
	}

	/** {@inheritDoc} </p> 
	 * 
	 * Overridden to permit size setting only
	 * if <code>width</code> is equal to <code>height</code>.
	 * 
	 */ 
	@Override
	public void setSize(int width, int height) {
		if (width == height)
			super.setSize(width, height);
	}

}