/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'SquareModel.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

/**
 * <code>SquareModel</code> is the interface for the data model of a square
 * figure. This interface is inherited from {@link RectangleModel}. </p>
 * 
 * A square is defined by its side length (which holds for all four sides of
 * it). Implementations of this interface should override
 * {@link #setSize(int, int)} and/ or {@link #setSize(java.awt.Dimension)} to
 * permit size setting only if the width and height are equal.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * @see RectangleModel
 * 
 */
public interface SquareModel extends RectangleModel {

	/**
	 * Gets the length of this model's square sides.
	 * 
	 * @return the current length
	 */
	int getLength();

	/**
	 * Sets the length of this model's square sides.
	 * 
	 * @param length
	 *            the new length
	 */
	void setLength(int length);

}
