/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'Swarm.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import geofasc.swing.Rectangle;

import java.awt.Color;

@SuppressWarnings("serial")
public class Discolight extends Rectangle {

	private Led[] mBigLamps, mSmallLamps1, mSmallLamps2;

	public Discolight() {
		super(50, 100, 500, 200);
		setFigureFilled(true);
		setFigureFillColor(Color.BLACK);

		mBigLamps = new Led[10];
		mSmallLamps1 = new Led[30];
		mSmallLamps2 = new Led[30];

		int x = 100;
		for (int i = 0; i <= 4; i = i + 1) {
			mBigLamps[i] = new Led(x, 40, 50, getRandomColor(),
					getRandomColor(), true);
			x = x + 60;
			add(mBigLamps[i]);
		}

		x = 100;
		for (int i = 5; i <= 9; i = i + 1) {

			mBigLamps[i] = new Led(x, 100, 50, getRandomColor(),
					getRandomColor(), true);
			x = x + 60;
			add(mBigLamps[i]);
		}

		int y = 9;
		for (int i = 0; i <= 9; i = i + 1) {
			mSmallLamps1[i] = new Led(10, y, 15, getRandomColor(),
					getRandomColor(), true);
			y = y + 18;
			add(mSmallLamps1[i]);
		}

		y = 9;
		for (int i = 10; i <= 19; i = i + 1) {
			mSmallLamps1[i] = new Led(30, y, 15, getRandomColor(),
					getRandomColor(), true);
			y = y + 18;
			add(mSmallLamps1[i]);
		}
		y = 9;
		for (int i = 20; i <= 29; i = i + 1) {
			mSmallLamps1[i] = new Led(50, y, 15, getRandomColor(),
					getRandomColor(), true);
			y = y + 18;
			add(mSmallLamps1[i]);
		}

		y = 9;
		for (int i = 0; i <= 9; i = i + 1) {
			mSmallLamps2[i] = new Led(435, y, 15, getRandomColor(),
					getRandomColor(), true);
			y = y + 18;
			add(mSmallLamps2[i]);
		}

		y = 9;
		for (int i = 10; i <= 19; i = i + 1) {
			mSmallLamps2[i] = new Led(455, y, 15, getRandomColor(),
					getRandomColor(), true);
			y = y + 18;
			add(mSmallLamps2[i]);
		}
		y = 9;
		for (int i = 20; i <= 29; i = i + 1) {
			mSmallLamps2[i] = new Led(475, y, 15, getRandomColor(),
					getRandomColor(), true);
			y = y + 18;
			add(mSmallLamps2[i]);
		}
	}

	public void disco() {

		Thread t = new Thread() {

			@Override
			public void run() {
				while (true) {
					int j = (int) (10 * Math.random());
					int k = (int) (30 * Math.random());
					mBigLamps[j].setOnColor(getRandomColor());
					delay(20 + (int) (70 * Math.random()));
					mSmallLamps1[k].setOnColor(getRandomColor());
					delay(20 + (int) (70 * Math.random()));
					mSmallLamps2[k].setOnColor(getRandomColor());
					delay(20 + (int) (70 * Math.random()));
				}
			}
		};
		t.start();
	}

	private Color getRandomColor() {
		return new Color((int) (254 * Math.random()), (int) (254 * Math
				.random()), (int) (254 * Math.random()));
	}

	private static void delay(int millisek) {
		try {
			Thread.sleep(millisek);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

}
