/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'Swarm.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.demo;

import java.awt.HeadlessException;

import javax.swing.SwingUtilities;

import geofasc.swing.tool.Frame;

@SuppressWarnings("serial")
public class PencilDemo extends Frame {

	private Pencil mPencil;

	public PencilDemo(String title) throws HeadlessException {
		super(title);
		mPencil = new Pencil(20, 20, getCanvas());
	}

	public void demo() {
		drawLines(50);
		mPencil.putUp();
		mPencil.moveTo(20, 80);
		mPencil.putDown();
		drawSomething(100);
		mPencil.putUp();
		mPencil.moveTo(20, 200);
		mPencil.putDown();
		drawSomethingNew(30);
	}
	
	private void drawSomething(int distance) {
		if (distance > 1) {
			mPencil.moveBy(distance);
			mPencil.turnAngleBy(90);
			drawSomething(distance - 5);
		}
	}
	
	private void drawSomethingNew(int distance) {
		int angle = 35;
		for (int i = 0; i < 2000; i++) {
			mPencil.moveBy(distance);
			mPencil.turnAngleBy(angle);
			distance = distance*9 / 10;
			angle -= 1;
		}
	}
	
	private void drawLines(int distance) {
		if (distance > 1) {
			mPencil.moveBy(distance);
			mPencil.putUp();
			mPencil.moveBy(5);
			mPencil.putDown();
			drawLines(distance * 9 / 10);
		}
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				PencilDemo frame = new PencilDemo(
						"Forms drawn by a pencil based on GeoFaSC class Polyline");
				frame.setCenterLocation();
				frame.setVisible(true);
				frame.demo();
			}
		});

	}

}
