/*
 * Copyright 2010 Christian Wolf, all rights reserved.
 * 
 * This file 'DefaultFigureModelExtended.java' is part of geofasc.
 * 
 * geofasc is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * geofasc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package geofasc.swing.model;

import java.awt.Dimension;
import java.awt.Rectangle;

/**
 * <code>DefaultFigureModelExtended</code> is the default implementation of
 * {@link FigureModelExtended}. This class is inherited from {@link DefaultFigureModel}.
 * 
 * @version 0.1 11/08/10
 * @author Christian Wolf
 * 
 */
public class DefaultFigureModelExtended extends DefaultFigureModel implements
		FigureModelExtended {

	private int mHeight;
	private int mWidth;

	/** {@inheritDoc} */
	@Override
	public Rectangle getBounds() {
		return new Rectangle(round(mLocationX), round(mLocationY), mWidth, mHeight);
	}

	/** {@inheritDoc} */
	@Override
	public void moveHeightBy(int dHeight) {
		setHeight(mHeight + dHeight);
	}

	/** {@inheritDoc} */
	@Override
	public void moveSizeBy(Dimension dSize) {
		if (dSize != null)
			setSize(mWidth + dSize.width, mHeight + dSize.height);
	}

	/** {@inheritDoc} */
	@Override
	public void moveSizeBy(int dWidth, int dHeight) {
		setSize(mWidth + dWidth, mHeight + dHeight);
	}

	/** {@inheritDoc} */
	@Override
	public void moveWidthBy(int dWidth) {
		setWidth(mWidth + dWidth);
	}

	/** {@inheritDoc} */
	@Override
	public void setBounds(int x, int y, int width, int height) {
		if (x == mLocationX && y == mLocationY && width == mWidth
				&& height == mHeight)
			return;

		mLocationX = x;
		mLocationY = y;
		mWidth = width;
		mHeight = height;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setBounds(Rectangle bounds) {
		if (bounds != null)
			setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
	}

	/** {@inheritDoc} */
	@Override
	public void setHeight(int height) {
		if (height == mHeight)
			return;

		mHeight = height;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setSize(Dimension size) {
		if (size != null)
			setSize(size.width, size.height);
	}

	/** {@inheritDoc} */
	@Override
	public void setSize(int width, int height) {
		if (width == mWidth && height == mHeight)
			return;

		mWidth = width;
		mHeight = height;
		fireStateChanged();
	}

	/** {@inheritDoc} */
	@Override
	public void setWidth(int width) {
		if (width == mWidth)
			return;

		mWidth = width;
		fireStateChanged();
	}

}
