import java.awt.Point;
import java.util.ArrayList;

import geofasc.swing.Circle;
import geofasc.swing.tool.Calculator;
import geofasc.swing.tool.Canvas;

/**
 * Eine <code>Bullet</code> kann sich mit einer Geschwindigkeit von 5 Pixeln
 * in eine bestimmbare Richtung bewegen. Sie ist ein {@link Circle} und 
 * wird auf einer {@link Canvas} visualisiert.
 * 
 */
public class Bullet extends Circle {

	private static final int sVelocity = 5; // Konstante Geschwindigkeit dieser Bullet in Pixeln

	private Canvas mCanvas;
	private ArrayList<Bullet> mNeighbours;  // Für a) unberuecksichtigt lassen! 

	// ------------------------------------------------------------------------
	// Sektion f. Aufgabenteil a) (erst spaeter auch fuer Teile von b) )
	
	/**
	 * Erzeugt eine neue <code>Bullet</code> bullet.
	 * 
	 * @param x die x-Koordinate von bullet bez. der canvas
	 * @param y die y-Koordinate von bullet bez. der canvas
	 * @param diameter der Radius des Kreises zur Visualisierung von bullet
	 * @param direction die initiale Richtung von bullet
	 * @param canvas die Zeichenflaeche, die bullet visualisiert
	 */
	public Bullet(int x, int y, int diameter, double direction, Canvas canvas) {
		// --------------------------
		// Ab HIER implementieren
		

		// Bis HIER implementieren
		// --------------------------
		mNeighbours = new ArrayList<Bullet>();
	}

	/**
	 * Bewegt diese bullet um 5 Pixel abhängig
	 * von ihrer Bewegungsrichtung.
	 */
	public void move() {
		// --------------------------
		// Ab HIER implementieren
		
	
		// Bis HIER implementieren
		// --------------------------
	}
	
	// ------------------------------------------------------------------------
	
	
	
	// ------------------------------------------------------------------------
	// Sektion f. Aufgabenteil b)
	
	/**
	 * Fuegt die Nachbarbullet b der Liste von Nachbarbullets dieser
	 * bullet hinzu.
	 * 
	 * @param b die Nachbarbullet
	 */
	public void addNeighbour(Bullet b) {
		if (b != null && !mNeighbours.contains(b))
			mNeighbours.add(b);
	}

	/**
	 * Gibt den Mittelpunkt des dieser bullet visualisierenden
	 * Kreises wieder. 
	 */
	public Point getCenter() {
		return new Point(getFigureLocationX() + getRadius(),
				getFigureLocationY() + getRadius());
	}

	/**
	 * Prueft fuer diese bullet, ob sie mit der <code>Bullet</code> b
	 * kollidiert.
	 * 
	 * @param b die Nachbarbullet
	 * @return true oder false
	 */
	public boolean hits(Bullet b) {
		// --------------------------
		// Ab HIER implementieren
		
		
		// Bis HIER implementieren
		// --------------------------
	}

	/**
	 * Entfernt die Nachbarbullet b aus der Liste von Nachbarbullets dieser
	 * bullet.
	 * 
	 * @param b die Nachbarbullet
	 */
	public void removeNeighbour(Bullet b) {
		mNeighbours.remove(b);
	}
	
	// ------------------------------------------------------------------------

}
