package aufgabe3;

import geofasc.swing.Circle;
import geofasc.swing.tool.Canvas;

import java.util.ArrayList;

/**
 * Ein <code>Ball</code> ist ein {@link Circle}, der sich innerhalb eines
 * Spielfeldes bewegt (in beliebige Richtungen). Kollidiert der
 * <code>Ball</code> an den oberen oder unteren Rand des Spielfeldes oder mit
 * einem beliebigen {@link Schlaeger}, so prallt er ab (unter Beruecksichtigung
 * seiner Richtung). Ein <code>Ball</code> positioniert sich mittig vom
 * Spielfeld, wenn er es ueber die linke oder rechte Spielfeldgrenze
 * ueberschritten hat.
 * 
 */
public class Ball extends Circle {

	private ArrayList<Schlaeger> mSchlaeger;
	private Thread mBewegeThread;

	/**
	 * Erzeugt einen neuen <code>Ball</code> b.
	 * 
	 * @param x die x-Koordinate von b bez. spielfeld
	 * @param y die y-Koordinate von b bez. spielfeld
	 * @param durchmesser der Durchmesser von b in Pixel
	 * @param spielfeld das Spielfeld von b
	 */
	public Ball(int x, int y, int durchmesser, Canvas spielfeld) {
		super(x, y, durchmesser);
		mSchlaeger = new ArrayList<Schlaeger>();
		spielfeld.add(this);
	}

	/**
	 * Nebenlaeufige Wrappermethode, die den Ball bewegt und Kollisionspruefungen
	 * vornimmt (es gibt eigentliche Methoden zur Bewegung und Kollisionspruefung,
	 * die aufgerufen werden).
	 */
	public void bewege() {
		if (mBewegeThread == null) {
			mBewegeThread = new Thread() {

				@Override
				public void run() {
					try {
						while (true && !isInterrupted()) {
							doBewege();
							pruefeSchlaegerKollision();
							pruefeSpielfeldKollision();
							sleep(50);
						}
					} catch (Exception e) {
					}
				}

			};
			mBewegeThread.start();
		}
	}

	/**
	 * Bewegt den Ball um einige Pixel.
	 */
	private synchronized void doBewege() {
		moveFigureLocationBy(5);
	}

	/**
	 * Macht den Schlaeger s diesem Ball bekannt.
	 * @param s ein Schlaeger
	 */
	public void lerneSchlaegerKennen(Schlaeger s) {
		if (s != null)
			mSchlaeger.add(s);
	}

	/**
	 * Prueft, ob der Ball mit den Schlaegern, die er kennt,
	 * kollidiert und aendert ggf. seine Richtung.
	 */
	private synchronized void pruefeSchlaegerKollision() {
		for (Schlaeger s : mSchlaeger) {
			int kollisionszahl = s.trifft(this);

			if (kollisionszahl == 0)
				setFigureDirection(360 - getFigureDirection());
			else if (kollisionszahl == 1)
				setFigureDirection(180 - getFigureDirection());
			else if (kollisionszahl == 2)
				setFigureDirection(360 - getFigureDirection());
			else if (kollisionszahl == 3)
				setFigureDirection(180 - getFigureDirection());
			else if (kollisionszahl == 10)
				setFigureDirection(180 + getFigureDirection());
			else if (kollisionszahl == 11)
				setFigureDirection(180 + getFigureDirection());
			else if (kollisionszahl == 12)
				setFigureDirection(180 + getFigureDirection());
			else if (kollisionszahl == 13)
				setFigureDirection(180 + getFigureDirection());
		}
	}

	/**
	 * Prueft, ob der Ball mit dem oberen oder unteren Spielfeldrand
	 * kollidiert und aendert ggf. so seine Richtung.
	 */
	private synchronized void pruefeSpielfeldKollision() {

		int x = getFigureLocationX();
		int y = getFigureLocationY();
		double dir = getFigureDirection();
		Canvas spielfeld = (Canvas) getParent();

		if (y <= 0 || (y + getFigureHeight()) >= getParent().getHeight())
			setFigureDirection(360 - dir);

		if ((x + getFigureWidth()) <= 0 || x >= spielfeld.getWidth()) {
			setFigureLocation(spielfeld.getWidth() / 2,
					spielfeld.getHeight() / 2);
			setFigureDirection(180 + getFigureDirection());
		}

	}

	/**
	 * Stoppt die nebenlaeufige Bewegung dieses Balls.
	 */
	public void stoppe() {
		if (mBewegeThread != null) {
			mBewegeThread.interrupt();
			mBewegeThread = null;
		}
	}

	/**
	 * Vergisst einen kennengelernten Schlaeger s.
	 * @param s ein Schlaeger
	 */
	public void vergissSchlaeger(Schlaeger s) {
		mSchlaeger.remove(s);
	}

}
