import geofasc.swing.Rectangle;

import java.awt.Color;

/**
 * Ein <code>DiscoLight</code> komponiert mehrere {@link LEDBar}s,
 * die zufaellig verteilt blinken.
 *
 */
public class DiscoLight extends Rectangle {

	private LEDBar mLeftElement, mMiddleElement, mRightElement;

	/**
	 * Erzeugt ein neues <code>DiscoLight</code>.
	 */
	public DiscoLight() {
		super(50, 100, 500, 200);
		setFigureFilled(true);
		setFigureFillColor(Color.BLACK);

		mLeftElement    = new LEDBar(5, 5, 10, 3);
		mMiddleElement  = new LEDBar(150, 50, 5, 10);
		mRightElement   = new LEDBar(430, 5, 10, 3);

		add(mLeftElement);
		add(mMiddleElement);
		add(mRightElement);
	}

	/** 
	 * Startet dieses <code>DiscoLight</code> und bringt
	 * die {@link LEDBar}s zum Leuchten.
	 */
	public void startDisco() {
		mLeftElement.startBlinking();
		mMiddleElement.startBlinking();
		mRightElement.startBlinking();
	}
	
	/** 
	 * Stoppt dieses <code>DiscoLight</code> und bringt
	 * die {@link LEDBar}s zum Erloeschen.
	 */
	public void stopDisco() {
		mLeftElement.stopBlinking();
		mMiddleElement.stopBlinking();
		mRightElement.stopBlinking();
	}

}
