import geofasc.swing.tool.Frame;

import java.awt.FlowLayout;
import java.awt.HeadlessException;

import javax.swing.SwingUtilities;

/**
 * Ein <code>DiscoLightDemo</code> stellt ein Hauptprogramm dar,
 * in dem mehrere {@link DiscoLight}s erzeugt und dargestellt
 * werden.
 *
 */
public class DiscoLightDemo extends Frame {

	/**
	 * Erzeugt ein neues <code>DiscoLightDemo</code>.
	 * 
	 * @param title der Titel dieses Fensters
	 */
	public DiscoLightDemo(String title) throws HeadlessException {
		super(title);
	}

	/**
	 * Erzeugt und stellt mehrere {@link Discolight}s dar.
	 */
	public void demo() {
		DiscoLight discoLight1 = new DiscoLight();
		DiscoLight discoLight2 = new DiscoLight();
		DiscoLight discoLight3 = new DiscoLight();

		getCanvas().setLayout(new FlowLayout());
		getCanvas().add(discoLight1, discoLight2, discoLight3);

		discoLight1.startDisco();
		discoLight2.startDisco();
		discoLight3.startDisco();
	}

	/**
	 * 	Hauptmethode zum Ausfuehren des Programms.
	 */
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				DiscoLightDemo frame = new DiscoLightDemo(
						"Disco lights demo based on GeoFaSC");
				frame.setCenterLocation();
				frame.setVisible(true);
				frame.demo();
			}
		});

	}

}
