 

import geofasc.swing.tool.Calculator;
import geofasc.swing.tool.Canvas;
import geofasc.swing.tool.Frame;

import javax.swing.SwingUtilities;

/**
 * Ein <code>BulletsMover</code> stellt ein Hauptprogramm dar,
 * in dem mehrere {@link Bullet}s erzeugt, bewegt und dargestellt
 * werden.
 *
 */
public class BulletsMover {
	
	private Bullet[] mBullets;
	private Thread mMovingThread; // Thread fuer die nebenlaeufige Bewegung aller Bullets
	private Frame mFrame;

	/**
	 * Erzeugt einen neuen <code>BulletsMover</code>.	
	 */
	public BulletsMover() {
		mBullets = new Bullet[20];
		mFrame = new Frame("Bullets");
		mMovingThread = null;
		init();
		mFrame.setCenterLocation();
		mFrame.setVisible(true);
	}

	/**
	 * Fuehrt diverse initiale Operationen aus.	
	 */
	private void init() {
		Canvas canvas = mFrame.getCanvas();

		double direction = 13;
		int x, y, diameter;
		Calculator calc = new Calculator();
		
		for (int i = 0; i < mBullets.length; i++, direction += 11) {
			x = calc.randomInt(10, 620);
			y = calc.randomInt(20, 460);
			diameter = calc.randomInt(5, 15);

			mBullets[i] = new Bullet(x, y, diameter, direction, canvas);
		}

		// --------------------------
		// Ab HIER implementieren
		
		
		// Bis HIER implementieren
		// --------------------------
	}
	
	/**
	 * Erzeugt einen Thread, in dem alle Bullets nebenlaeufig bewegt werden.
	 */
	public void move() {
		if (mMovingThread == null) {
			mMovingThread = new Thread() {

				@Override
				public void run() {
					try {
						while (true) {
							if (isInterrupted())
								break;
							
							for (Bullet bullet : mBullets) {
								bullet.move();
							}
							sleep(50);
						}
					}// try
					catch (Exception e) {
					}
				}
			};

			mMovingThread.start();
		}
	}

	/**
	 * Stoppt die nebenlaeufige Bewegung der Bullets.
	 */
	public void stop() {
		if (mMovingThread != null) {
			mMovingThread.interrupt();
			mMovingThread = null;
		}
	}
	
	/**
	 * 	Hauptmethode zum Ausfuehren des Programms.
	 */
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				BulletsMover bm = new BulletsMover();
				bm.move();
			}
		});

	}
	
}
