import geofasc.swing.Circle;

import java.awt.Color;

/**
 * Eine <code>LED</code> hat die festgelegten Zustände <code>an</code>,
 * <code>aus</code> und <code>blinkend</code>. Beim Uebergang und Befinden in
 * diesen Zustaenden loest eine <code>LED</code> eine passende Aktion aus.
 */
public class LED extends Circle {

	private int mState;
	private Color mOnColor;
	private Color mOffColor;
	private Thread mBlinkThread;

	/**
	 * Erzeugt eine neue <code>LED</code> led.
	 * 
	 * @param x
	 *            die x-Koordinate von led bez. des Eltercontainers
	 * @param y
	 *            die y-Koordinate von led bez. des Eltercontainers
	 * @param diameter
	 *            der Durchmesser von led
	 * @param onColor
	 *            die An-Farbe von led
	 * @param offColor
	 *            die Aus-Farbe von led
	 */
	public LED(int x, int y, int diameter, Color onColor, Color offColor) {
		super(x, y, diameter);
		setFigureFilled(true);

		mOnColor = onColor;
		mOffColor = offColor;

		mState = 2;
		actionOff();
	}

	/**
	 * Schaltet die verschiedenen Zustaende dieser LED durch.
	 */
	public void doSwitch() {
		if (mState == 0) { // off -> on
			mState = mState + 1;
			actionOn();
		} else if (mState == 1) { // on -> blinking
			mState = mState + 1;
			actionBlinking();
		} else if (mState == 2) { // blinking -> off
			mState = 0;
			actionOff();
		}
	}

	/**
	 * Eine ausgeloeste Aktion.
	 */
	private void actionOn() {
		interruptBlinkingThread();
		setFigureFillColor(mOnColor);
	}

	/**
	 * Eine ausgeloeste Aktion.
	 */
	private void actionOff() {
		interruptBlinkingThread();
		setFigureFillColor(mOffColor);
	}

	/**
	 * Eine ausgeloeste Aktion.
	 */
	private void actionBlinking() {

		if (mBlinkThread != null)
			return;

		mBlinkThread = new Thread() {

			public void run() {
				try {
					// Bis hierher technischer Code
					// --------------------------------------

					while (mState == 2 && !isInterrupted()) {
						setFigureFillColor(mOnColor);
						sleep(100);
						setFigureFillColor(mOffColor);
						sleep(300);
					}

					// --------------------------------------
					// Ab hier wieder technischer Code

				} catch (Exception e) {
				}

			};
		};
		mBlinkThread.start();
	}

	/**
	 * Loest eine Unterbrechungsanforderung fuer den Thread zum nebenlaeufigen
	 * Blinken aus.
	 */
	private void interruptBlinkingThread() {
		if (mBlinkThread != null) {
			mBlinkThread.interrupt();
			mBlinkThread = null;
		}
	}

}
