 

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

/**
 * Ein <code>TastaturEreignisBearbeiter</code> ist für die Verarbeitung
 * bestimmter Tastatureingaben, mit denen ein {@link Schlaeger} bewegt wird,
 * verantwortlich.
 * 
 */
public class TastaturEreignisBearbeiter extends KeyAdapter {

	private int mKeyCode1, mKeyCode2;
	private Schlaeger mSchlaeger;

	/**
	 * Erzeugt einen neuen <code>TastaturEreignisBearbeiter</code>.
	 * 
	 * @param s
	 *            der Schlaeger der bewegt werden soll
	 * @param charKeyCode1
	 *            der Tastatur-Code zum Hochbewegen von s
	 * @param charKeyCode2
	 *            der Tastatur-Code zum Runterbewegen von s
	 */
	public TastaturEreignisBearbeiter(Schlaeger s, int charKeyCode1,
			int charKeyCode2) {
		mSchlaeger = s;
		mKeyCode1 = charKeyCode1;
		mKeyCode2 = charKeyCode2;
	}

	/**
	 * Methode zum Verarbeiten von Tastaturereignissen.
	 * 
	 * @param e
	 *            das Objekt mit diversen Informationen ueber das
	 *            Tastaturereignis
	 */
	@Override
	public void keyPressed(KeyEvent e) {
		if (e.getKeyCode() == mKeyCode1)
			mSchlaeger.bewegeHoch();
		else if (e.getKeyCode() == mKeyCode2)
			mSchlaeger.bewegeRunter();
	}

}
