package aufgabe3;

import geofasc.swing.Rectangle;
import geofasc.swing.tool.Canvas;

import java.awt.Point;

import javax.swing.SwingUtilities;

/**
 * Ein <code>Schlaeger</code> ist ein {@link Rectangle}, den man hoch
 * und runter bewegen kann. Zudem kann er fuer einen {@link Ball} ueberpruefen,
 * ob und wie der dieser ihn trifft.
 *
 */
public class Schlaeger extends Rectangle {

	/**
	 * Erzeugt einen neuen <code>Schlaeger</code> s.
	 * 
	 * @param x die x-Koordinate von s bez. spielfeld
	 * @param y die y-Koordinate vons bez. spielfeld
	 * @param width die Breite von s in Pixel
	 * @param height die Hoehe von s in Pixel
	 * @param spielfeld das spielfeld von s
	 */
	public Schlaeger(int x, int y, int width, int height, Canvas spielfeld) {
		super(x, y, width, height);
		spielfeld.add(this);
	}

	/**
	 * Bewegt diesen <code>Schlaeger</code> einige Pixel hoch.
	 */
	public void bewegeHoch() {
		super.moveFigureLocationYBy(-10);
	}

	/**
	 * Bewegt diesen <code>Schlaeger</code> einige Pixel runter.
	 */
	public void bewegeRunter() {
		super.moveFigureLocationYBy(10);
	}

	/**
	 * Ueberprueft, ob und wie dieser Schlaeger mit einem Ball ball kollidiert 
	 * und gibt diese Information als Kollisionszahl wie folgt zurueck:
	 * 
	 * -1  = keine Kollision, 
	 *  0  = obere Seite, 
	 *  1  = rechte Seite, 
	 *  2  = untere Seite, 
	 *  3  = linke Seite,
	 *  10 = linke obere Ecke, 
	 *  11 = rechte obere Ecke, 
	 *  12 = rechte untere Ecke,
	 *  13 = linke untere Ecke
	 * 
	 * @param ball der Ball fuer den die Kollisionszahl berechnet wird
	 * @return die Kollisionszahl
	 */
	public int trifft(Ball ball) {

		if (ball == null)
			return -1;

		// Eckpunkte der Bounding-Box von ball bestimmen

		Point bLinksOben = ball.getFigureLocation();

		Point bRechtsOben = ball.getFigureLocation();
		bRechtsOben.x += ball.getFigureWidth();

		Point bLinksUnten = ball.getFigureLocation();
		bLinksUnten.y += ball.getFigureHeight();

		Point bRechtsUnten = ball.getFigureLocation();
		bRechtsUnten.x += ball.getFigureWidth();
		bRechtsUnten.y += ball.getFigureHeight();

		// Eckpunkte von ball in Koordinaten bezueglich dieses Schlaegers
		// umrechnen
		
		bLinksOben = SwingUtilities.convertPoint(getParent(), bLinksOben, this);
		bLinksUnten = SwingUtilities.convertPoint(getParent(), bLinksUnten,
				this);
		bRechtsOben = SwingUtilities.convertPoint(getParent(), bRechtsOben,
				this);
		bRechtsUnten = SwingUtilities.convertPoint(getParent(), bRechtsUnten,
				this);

		// Kollisionsueberpruefungen

		// linke obere Ecke

		if (contains(bRechtsUnten)
				&& !contains(bLinksOben)
						&& !contains(bLinksUnten) && !contains(bRechtsOben))
			return 10;

		// rechte obere Ecke

		else if (contains(bLinksUnten) && !contains(bLinksOben)
				&& !contains(bRechtsOben) && !contains(bRechtsUnten))
			return 11;

		// rechte untere Ecke

		else if (contains(bLinksOben) && !contains(bLinksUnten)
				&& !contains(bRechtsOben) && !contains(bRechtsUnten))
			return 12;
		
		// linke untere Ecke

		else if (contains(bRechtsOben) && !contains(bLinksOben)
				&& !contains(bLinksUnten) && !contains(bRechtsUnten))
			return 13;

		// oben

		if (contains(bLinksUnten) && contains(bRechtsUnten))
			return 0;

		// rechts

		else if (contains(bLinksOben) && contains(bLinksUnten))
			return 1;

		// unten

		else if (contains(bLinksOben) && contains(bRechtsOben))
			return 2;

		// links

		else if (contains(bRechtsUnten) && contains(bRechtsOben))
			return 3;

		else
			return -1;
	}

}
